* PROGRAM NAME: PBP_IMPORT.SAS;
* DESCRIPTION: IMPORT THE INDIVIDUAL PBP TABLES AND MERGE TOGETHER;

*FROM MAIN CALLING PROGRAM;

LIBNAME LIBRARY "&INPUTDIR";
LIBNAME PBP ACCESS "&PBP\PBP&RUNYEAR..MDB";


%MACRO FMTALL;
  %IF &NUM > 0 %THEN %DO;
    DATA HPLAN_ALL_FMT (KEEP=START LABEL HLO FMTNAME);
    SET MASTER_PLANFILE (RENAME=HPLAN=START) END=LAST;
    LENGTH FMTNAME $9 LABEL $3 HLO $1;
    FMTNAME='$HPLANALL';
    LABEL='YES';
    HLO=' ';
    OUTPUT;
    IF LAST THEN DO;
      START='OTHER';
      LABEL='NO';
      HLO='O';
      OUTPUT;
    END;
    RUN;
  %END;
  %ELSE %DO;
    DATA HPLAN_ALL_FMT (KEEP=START LABEL HLO FMTNAME);
    LENGTH FMTNAME $9 LABEL $3 HLO $1;
    FMTNAME='$HPLANALL';
    START='OTHER';
    LABEL='YES';
    HLO='O';
    OUTPUT;
    RUN;
  %END;
  RUN;
%MEND;   

%FMTALL;
RUN;

PROC FORMAT CNTLIN=HPLAN_ALL_FMT LIB=LIBRARY;
RUN;

%MACRO FMTPLAN;
  %IF &NUM > 0 %THEN %DO;
    DATA HPLAN_FMT (KEEP=START LABEL HLO FMTNAME);
      SET PLANFILE (RENAME=HPLAN=START) END=LAST;
      LENGTH FMTNAME $8 LABEL $3 HLO $1;
      FMTNAME='$HPLANF';
      LABEL='YES';
      HLO=' ';
      OUTPUT;
      IF LAST THEN DO;
        START='OTHER';
        LABEL='NO';
        HLO='O';
        OUTPUT;
      END;
    RUN;
  %END;
  %ELSE %DO;
    DATA HPLAN_FMT (KEEP=START LABEL HLO FMTNAME);
      LENGTH FMTNAME $8 LABEL $3 HLO $1;
      FMTNAME='$HPLANF';
      START='OTHER';
      LABEL='YES';
      HLO='O';
      OUTPUT;
    RUN;
  %END;
  RUN;
%MEND;

%FMTPLAN;
RUN;

PROC FORMAT CNTLIN=HPLAN_FMT LIB=LIBRARY;
RUN;

DATA PBPPLANS PBPPLANS_ALL;
  LENGTH PBP_A_CONTRACT_NUMBER $5 PBP_A_PLAN_IDENTIFIER $3 PBP_A_SEGMENT_ID $3; 
  KEEP QID
  PBP_A_PLAN_TYPE
  PBP_A_ORG_TYPE
  PBP_A_PLAN_NAME
  PBP_A_ORG_NAME
  PBP_A_SPECIAL_NEED_FLAG
  PBP_A_SPECIAL_NEED_PLAN_TYPE
  PBP_A_SNP_PCT
  PBP_A_CONTRACT_NUMBER 
  PBP_A_PLAN_IDENTIFIER
  PBP_A_SEGMENT_ID;
  SET PBP.PBP (RENAME=QID=QID_OLD);
  LENGTH QID $11;
  QID=SUBSTR(QID_OLD,1,11);
  PBP_A_CONTRACT_NUMBER = SUBSTR(QID,1,5);
  PBP_A_PLAN_IDENTIFIER = SUBSTR(QID,6,3);
  PBP_A_SEGMENT_ID = SUBSTR(QID,9,3);
  IF PUT(QID,$HPLANF.) = 'YES' THEN OUTPUT PBPPLANS;
  IF PUT(QID,$HPLANALL.) = 'YES' THEN OUTPUT PBPPLANS_ALL;
RUN;

PROC SORT DATA=PBPPLANS;
  BY QID;
RUN;

PROC SORT DATA=PBPPLANS_ALL;
  BY QID;
RUN;

DATA PBP_DRUG (DROP=QID_OLD)
     PBP_DRUG_ALL (DROP=QID_OLD);
  SET PBP.PBPMRX (RENAME=QID=QID_OLD);
  LENGTH QID $11;
  QID=SUBSTR(QID_OLD,1,11);
  IF PUT(QID,$HPLANF.) = 'YES' THEN OUTPUT PBP_DRUG;
  IF PUT(QID,$HPLANALL.) = 'YES' THEN OUTPUT PBP_DRUG_ALL;
RUN;

PROC SORT DATA=PBP_DRUG;
  BY QID;
RUN;

PROC SORT DATA=PBP_DRUG_ALL;
  BY QID;
RUN;

DATA PBPPLANS_ALL;
  LENGTH TYPE $4;
  MERGE PBPPLANS_ALL (IN=IN1) 
        PBP_DRUG_ALL (IN=IN2);
  BY QID;
  IF IN1;
  IF NOT IN2 THEN PBP_MRX_DRUG_YN = '2';
  IF PBP_A_PLAN_TYPE IN('29','30','32') THEN TYPE = 'PDP';
  ELSE TYPE = 'MAPD';
  IF TYPE = 'MAPD' THEN DO;
    IF MRX_DRUG_BEN_YN = '2' THEN TYPE = 'MAON';
  END;
  IF PBP_A_ORG_TYPE='02' AND PBP_A_PLAN_TYPE='07' THEN TYPE = 'MSA';
RUN;

DATA PBPPLANS MAPD MAON PDP MSA FFS MGAP;
  LENGTH TYPE $4;
  MERGE PBPPLANS (IN=IN1) 
        PBP_DRUG (IN=IN2);
  BY QID;
  IF IN1;
  IF NOT IN2 THEN PBP_MRX_DRUG_YN = '2';
  IF PBP_A_PLAN_TYPE IN('29','30','32') THEN TYPE = 'PDP';
  ELSE TYPE = 'MAPD';
  IF TYPE = 'MAPD' THEN DO;
    IF MRX_DRUG_BEN_YN = '2' THEN TYPE = 'MAON';
  END;
  IF PBP_A_ORG_TYPE='02' AND PBP_A_PLAN_TYPE='07' THEN TYPE = 'MSA';
  IF TYPE = 'PDP' THEN OUTPUT PDP;
  ELSE IF TYPE = 'MAPD' THEN OUTPUT MAPD;
  ELSE IF TYPE = 'MAON' THEN OUTPUT MAON;
  ELSE IF TYPE = 'MSA' THEN OUTPUT MSA;
  ELSE IF TYPE = 'FFS' THEN OUTPUT FFS;
  ELSE IF TYPE = 'MGAP' THEN OUTPUT MGAP;
  OUTPUT PBPPLANS;
RUN;

%GLOBAL MAON PDP MAPD MSA;
RUN;

DATA _NULL_;
  CALL SYMPUT('MAON',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET MAON NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('PDP',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET PDP NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('MAPD',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET MAPD NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('MSA',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET MSA NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('FFS',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET FFS NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('MGAP',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET MGAP NOBS=NUMOBS;
  STOP;
RUN;

%PUT _USER_;

DATA _NULL_;
  CALL SYMPUT('NUM',TRIM(LEFT(PUT(NUMOBS,4.))));
  STOP;
  SET PBPPLANS NOBS=NUMOBS;
  STOP;
RUN;

%MACRO FMTTYPE;
  %IF &NUM > 0 %THEN %DO;
    DATA PLAN_FMT (KEEP=START LABEL HLO FMTNAME);
      SET PBPPLANS (RENAME=QID=START) END=LAST;
      LENGTH FMTNAME $8 LABEL $4 HLO $1;
      FMTNAME='$TYPEF';
      LABEL=TYPE;
      HLO=' ';
      OUTPUT;
      IF LAST THEN DO;
        START='OTHER';
        LABEL='NO';
        HLO='O';
        OUTPUT;
      END;
    RUN;
  %END;
  %ELSE %DO;
    DATA PLAN_FMT (KEEP=START LABEL HLO FMTNAME);
      LENGTH FMTNAME $8 LABEL $4 HLO $1;
      FMTNAME='$TYPEF';
      START='OTHER';
      LABEL='NO';
      HLO='O';
      OUTPUT;
    RUN;
  %END;
  RUN;
%MEND;

%FMTTYPE;
RUN;

PROC FORMAT CNTLIN=PLAN_FMT LIB=LIBRARY;
RUN;

%MACRO FMTTYPEALL;
  %IF &NUM > 0 %THEN %DO;
    DATA PLAN_FMT_ALL (KEEP=START LABEL HLO FMTNAME);
    SET PBPPLANS_ALL (RENAME=QID=START) END=LAST;
    LENGTH FMTNAME $8 LABEL $4 HLO $1;
    FMTNAME='$TYPEALL';
    LABEL=TYPE;
    HLO=' ';
    OUTPUT;
    IF LAST THEN DO;
      START='OTHER';
      LABEL='NO';
      HLO='O';
      OUTPUT;
    END;
    RUN;
  %END;
  %ELSE %DO;
    DATA PLAN_FMT_ALL (KEEP=START LABEL HLO FMTNAME);
    LENGTH FMTNAME $8 LABEL $4 HLO $1;
    FMTNAME='$TYPEALL';
    START='OTHER';
    LABEL='NO';
    HLO='O';
    OUTPUT;
    RUN;
  %END;
  RUN;
%MEND;

%FMTTYPEALL;
RUN;

PROC FORMAT CNTLIN=PLAN_FMT_ALL LIB=LIBRARY;
RUN;

DATA CONTPLAN;
  LENGTH START $8;
  RETAIN FMTNAME '$CONTPLNF';
  SET PLAN_FMT(RENAME=START=HPLAN DROP=FMTNAME);
  START = SUBSTR(HPLAN,1,8);
RUN;

PROC SORT DATA = CONTPLAN NODUPKEY;
  BY START;
RUN;

PROC FORMAT CNTLIN=CONTPLAN LIB=LIBRARY;
RUN;

PROC SORT DATA=PBPPLANS;
  BY QID;
RUN;

DATA PBP;
  SET PBP.PBP (RENAME=QID=QID_OLD);
  LENGTH QID $11;
  QID=SUBSTR(QID_OLD,1,11);
  DROP QID_OLD;
  IF PUT(QID,$HPLANF.) = 'YES';
RUN;

PROC SORT DATA= PBP;
  BY QID;
RUN;

%INCLUDE IN0(CONVERT);
RUN;

PROC SORT DATA=PBP.HISTORY OUT=HISTORY;
  BY QID DAYTIME;
RUN;

DATA HISTORY (KEEP=QID DAYTIME);
  SET HISTORY;
  BY QID DAYTIME;
  IF LAST.QID;
RUN;

DATA HISTORY_FMT (KEEP=START LABEL HLO FMTNAME);
  SET HISTORY END=LAST;
  LENGTH FMTNAME $8 HLO $1 START $11 LABEL $21;
  RETAIN FMTNAME '$HISTFMT' HLO ' ';
  START=SUBSTR(LEFT(QID),1,11);
  LABEL=PUT(DAYTIME,datetime21.);
  OUTPUT;
  IF LAST THEN DO;
    START='OTHER';
    LABEL=.;
    HLO='O';
    OUTPUT;
  END;
RUN;

PROC FORMAT CNTLIN=HISTORY_FMT LIB=LIBRARY;
RUN;

%PBPIMPCONV(PBPD);
RUN;

%PBPIMPCONV(PBPD_1);
RUN;

%MACRO BUILDFILE;

  DATA PBP_FILE(RENAME=QID=HPLAN);
    MERGE PBPPLANS(IN=INPLAN
        RENAME=(PBP_A_CONTRACT_NUMBER=CONTRACT_ID PBP_A_PLAN_IDENTIFIER=PLAN_ID PBP_A_SEGMENT_ID=SEGMENT_ID))
    PBP(DROP=PBP_A_CONTRACT_NUMBER PBP_A_PLAN_IDENTIFIER PBP_A_SEGMENT_ID PBP_A_PLAN_NAME PBP_A_PLAN_TYPE
      PBP_A_ORG_TYPE PBP_A_ORG_NAME PBP_A_SPECIAL_NEED_FLAG PBP_A_SPECIAL_NEED_PLAN_TYPE PBP_A_SNP_PCT)
    PBPD;
    BY QID;
    IF INPLAN;
 
    ARRAY DIV100 _NUMERIC_;
  
    DO I = 1 TO DIM(DIV100);
      IF INDEX(UPCASE(VNAME(DIV100(I))),"COINS") > 0 & INDEX(UPCASE(VNAME(DIV100(I))),"PCT") > 0 & DIV100(I) NE . THEN
        DIV100(I) = DIV100(I) / 100.0;
    END;
  RUN;

%MEND;

%BUILDFILE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
  DELETE PBPPLANS PBP PBPD PBPD_1
  NEWPBPD NEWPBPD_1;
  QUIT;
RUN;
